/*
 * Decompiled with CFR 0.152.
 */
package benchmark;

import benchmark.BenchThread;
import benchmark.Benchable;
import benchmark.DoubleBench;
import benchmark.FloatBench;
import benchmark.IntBench;
import benchmark.LongBench;
import benchmark.MemoryBench;
import common.lang.StringUtil;
import java.text.NumberFormat;

public class Bench {
    private static NumberFormat numFormat = NumberFormat.getIntegerInstance();

    public static int test(Benchable benchable, int n) {
        int n2;
        if (n > 64 || n < 1) {
            throw new IllegalArgumentException("numThreads must be between 1 - 64");
        }
        BenchThread[] benchThreadArray = new BenchThread[n];
        for (n2 = 0; n2 < n; ++n2) {
            benchThreadArray[n2] = new BenchThread(benchable.duplicate());
        }
        n2 = 0;
        for (int i = 0; i < n; ++i) {
            try {
                benchThreadArray[i].join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            n2 += benchThreadArray[i].getTime();
        }
        return n2 / n / n;
    }

    public static String testFive(int n) {
        IntBench intBench = new IntBench();
        LongBench longBench = new LongBench();
        FloatBench floatBench = new FloatBench();
        DoubleBench doubleBench = new DoubleBench();
        MemoryBench memoryBench = new MemoryBench();
        int n2 = Bench.test(intBench, n);
        int n3 = Bench.test(longBench, n);
        int n4 = 0;
        int n5 = Bench.test(doubleBench, n);
        int n6 = Bench.test(memoryBench, n);
        int n7 = n2 + n3 + n4 + n5 + n6;
        String string = StringUtil.getLineSeparator();
        return "int score = " + numFormat.format(n2) + string + "long score = " + numFormat.format(n3) + string + "double score = " + numFormat.format(n5) + string + "memory score = " + numFormat.format(n6) + string + "--------------------" + string + "total score = " + numFormat.format(n7);
    }

    public static void main(String[] stringArray) {
        int n = 1;
        if (stringArray.length > 0) {
            n = Integer.parseInt(stringArray[0]);
        }
        int n2 = Runtime.getRuntime().availableProcessors();
        System.out.println("This machine has " + n2 + " virtual cpu's.");
        System.out.println("Running test using " + n + " threads...");
        System.out.println("This will take a couple minutes...");
        String string = Bench.testFive(n);
        System.out.println("---- Lower scores are better ----");
        System.out.println(string);
    }
}

