/*
 * Decompiled with CFR 0.152.
 */
package benchmark;

import benchmark.Bench;
import common.lang.StringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class BenchPanel
extends JPanel
implements ActionListener,
Runnable {
    private static final String lineSep = StringUtil.getLineSeparator();
    private final JButton goButton = new JButton(" Go ");
    private final JButton clearButton = new JButton("Clear");
    private final JComboBox cpuComboBox = new JComboBox();
    private final JTextArea textArea = new JTextArea(10, 40);
    private final Cursor waitCursor = new Cursor(3);
    private final NumberFormat numFormat = NumberFormat.getIntegerInstance();

    public BenchPanel() {
        this.setupLayout();
        this.goButton.addActionListener(this);
        this.clearButton.addActionListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.goButton) {
            this.cpuComboBox.setEnabled(false);
            this.goButton.setEnabled(false);
            this.clearButton.setEnabled(false);
            this.setCursor(this.waitCursor);
            new Thread(this).start();
        } else if (object == this.clearButton) {
            this.textArea.setText("");
        }
    }

    public void run() {
        Integer n = (Integer)this.cpuComboBox.getSelectedItem();
        this.textArea.append("Running test using " + n + " threads...");
        this.textArea.append(lineSep);
        String string = Bench.testFive(n);
        this.textArea.append(string);
        this.textArea.append(lineSep);
        this.textArea.append(lineSep);
        this.setCursor(Cursor.getDefaultCursor());
        this.cpuComboBox.setEnabled(true);
        this.goButton.setEnabled(true);
        this.clearButton.setEnabled(true);
    }

    private void setupLayout() {
        int n;
        this.textArea.setEditable(false);
        for (int i = n = Runtime.getRuntime().availableProcessors(); i > 0; --i) {
            this.cpuComboBox.addItem(new Integer(i));
        }
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        jPanel.add(new JLabel("# threads"));
        jPanel.add(this.cpuComboBox);
        jPanel.add(this.goButton);
        jPanel.add(this.clearButton);
        this.add((Component)jPanel, "North");
        this.add((Component)new JScrollPane(this.textArea), "Center");
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("Benchmark");
        jFrame.setDefaultCloseOperation(3);
        Container container = jFrame.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)new BenchPanel(), "Center");
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

