/*
 * Decompiled with CFR 0.152.
 */
package common.lang;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class StringUtil {
    public static String right(String string, int n) {
        if (string == null) {
            return null;
        }
        if (string.length() == 0 || n < 1) {
            return "";
        }
        if (string.length() <= n) {
            return string;
        }
        return string.substring(string.length() - n, string.length());
    }

    public static String left(String string, int n) {
        if (string == null) {
            return null;
        }
        if (string.length() == 0 || n < 1) {
            return "";
        }
        if (string.length() <= n) {
            return string;
        }
        return string.substring(0, n);
    }

    public static String replace(String string, String string2, String string3) {
        int n = string.indexOf(string2);
        if (n == -1) {
            return string;
        }
        int n2 = string3.length() - string2.length();
        StringBuilder stringBuilder = new StringBuilder(string.length() + n2);
        int n3 = 0;
        while (n != -1) {
            stringBuilder.append(string.substring(n3, n));
            stringBuilder.append(string3);
            n3 = n + string2.length();
            n = string.indexOf(string2, n3);
        }
        stringBuilder.append(string.substring(n3));
        return stringBuilder.toString();
    }

    public static int indexOfIgnoreCase(String string, String string2) {
        return StringUtil.indexOfIgnoreCase(string, string2, 0);
    }

    public static int indexOfIgnoreCase(String string, String string2, int n) {
        int n2 = 0;
        if (string2.length() == 0) {
            return n;
        }
        String string3 = string2.toLowerCase();
        for (int i = n; i < string.length(); ++i) {
            char c;
            char c2 = string3.charAt(n2);
            if (c2 == (c = Character.toLowerCase(string.charAt(i)))) {
                if (++n2 != string2.length()) continue;
                return n;
            }
            n2 = 0;
            n = i + 1;
        }
        return -1;
    }

    public static int indexOfAnyOf(String string, String string2) {
        return StringUtil.indexOfAnyOf(string, string2, 0);
    }

    public static int indexOfAnyOf(String string, String string2, int n) {
        if (n < 0) {
            n = 0;
        }
        for (int i = n; i < string.length(); ++i) {
            char c = string.charAt(i);
            for (int j = 0; j < string2.length(); ++j) {
                if (c != string2.charAt(j)) continue;
                return i;
            }
        }
        return -1;
    }

    public static int lastIndexOfAnyOf(String string, String string2) {
        return StringUtil.lastIndexOfAnyOf(string, string2, string.length() - 1);
    }

    public static int lastIndexOfAnyOf(String string, String string2, int n) {
        int n2 = string.length() - 1;
        if (n > n2) {
            n = n2;
        }
        for (int i = n; i >= 0; --i) {
            char c = string.charAt(i);
            for (int j = 0; j < string2.length(); ++j) {
                if (c != string2.charAt(j)) continue;
                return i;
            }
        }
        return -1;
    }

    public static boolean isWhitespace(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isWhitespace(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNullOrWhitespace(String string) {
        return string == null || StringUtil.isWhitespace(string);
    }

    public static boolean containsWhitespace(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (!Character.isWhitespace(string.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean equals(String string, String string2) {
        if (string == null || string2 == null) {
            return string == string2;
        }
        return string.equals(string2);
    }

    public static boolean equalsIgnoreCase(String string, String string2) {
        if (string == null || string2 == null) {
            return string == string2;
        }
        return string.equalsIgnoreCase(string2);
    }

    public static boolean startsWithIgnoreCase(String string, String string2) {
        return string.regionMatches(true, 0, string2, 0, string2.length());
    }

    public static boolean endsWithIgnoreCase(String string, String string2) {
        int n = string.length() - string2.length();
        return string.regionMatches(true, n, string2, 0, string2.length());
    }

    public static boolean contains(String string, char c) {
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != c) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(String string, String string2) {
        return string.indexOf(string2) != -1;
    }

    public static boolean containsIgnoreCase(String string, String string2) {
        return StringUtil.indexOfIgnoreCase(string, string2) != -1;
    }

    public static boolean containsOnly(String string, String string2) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (string2.indexOf(c) != -1) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAnyOf(String string, String string2) {
        return StringUtil.indexOfAnyOf(string, string2) != -1;
    }

    public static boolean equalsAnyOf(String string, String[] stringArray) {
        if (string == null || stringArray == null) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean equalsAnyOf(String string, ArrayList arrayList) {
        if (string == null || arrayList == null) {
            return false;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            if (!string.equals(arrayList.get(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean equalsAnyOfIgnoreCase(String string, String[] stringArray) {
        if (string == null || stringArray == null) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equalsIgnoreCase(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean equalsAnyOfIgnoreCase(String string, ArrayList arrayList) {
        if (string == null || arrayList == null) {
            return false;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            if (!string.equalsIgnoreCase((String)arrayList.get(i))) continue;
            return true;
        }
        return false;
    }

    public static String createStringOfLength(int n, char c) {
        if (n <= 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static int[] lineAndCharForPosition(String string, int n) {
        int n2 = 1;
        int n3 = 0;
        for (int i = 0; i <= n; ++i) {
            if (string.charAt(i) != '\n') continue;
            ++n2;
            n3 = i;
        }
        int[] nArray = new int[]{n2, n - n3};
        return nArray;
    }

    public static String stripLeading(String string, char c) {
        int n;
        if (string == null) {
            return null;
        }
        for (n = 0; n < string.length() && string.charAt(n) == c; ++n) {
        }
        if (n == 0) {
            return string;
        }
        return string.substring(n);
    }

    public static String stripWhitespace(String string) {
        if (string == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isWhitespace(c)) continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static String stripAnyOf(String string, String string2) {
        if (string == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (string2.indexOf(c) != -1) continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static String arrayToString(Object[] objectArray, String string) {
        if (objectArray == null) {
            return null;
        }
        if (string == null) {
            string = "\n";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < objectArray.length; ++i) {
            if (i > 0) {
                stringBuilder.append(string);
            }
            stringBuilder.append(objectArray[i]);
        }
        return stringBuilder.toString();
    }

    public static String collectionToString(Collection collection, String string) {
        if (collection == null) {
            return null;
        }
        if (string == null) {
            string = "\n";
        }
        StringBuilder stringBuilder = new StringBuilder();
        Iterator iterator = collection.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (n > 0) {
                stringBuilder.append(string);
            }
            stringBuilder.append(e);
            ++n;
        }
        return stringBuilder.toString();
    }

    public static String mapToString(Map map, String string) {
        if (map == null) {
            return null;
        }
        if (string == null) {
            string = "\n";
        }
        StringBuilder stringBuilder = new StringBuilder();
        Set set = map.keySet();
        Iterator iterator = set.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Object k = iterator.next();
            Object v = map.get(k);
            if (n > 0) {
                stringBuilder.append(string);
            }
            stringBuilder.append(k);
            stringBuilder.append(" = ");
            stringBuilder.append(v);
            ++n;
        }
        return stringBuilder.toString();
    }

    public static String compressWhitespace(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length());
        int n = 0;
        char c = string.charAt(n);
        while (Character.isWhitespace(c)) {
            c = string.charAt(++n);
        }
        boolean bl = false;
        for (int i = n; i < string.length(); ++i) {
            char c2 = string.charAt(i);
            boolean bl2 = Character.isWhitespace(c2);
            if (bl2) {
                c2 = ' ';
                if (!bl) {
                    stringBuilder.append(c2);
                }
            } else {
                stringBuilder.append(c2);
            }
            bl = bl2;
        }
        if (Character.isWhitespace(string.charAt(string.length() - 1))) {
            stringBuilder.setLength(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }

    public static String breakUpVeryLongWords(String string, int n, String string2) {
        if (string == null) {
            return null;
        }
        if (string.length() < n || string2 == null) {
            return string;
        }
        int n2 = string.length() + string2.length() * (string.length() / n);
        StringBuilder stringBuilder = new StringBuilder(n2);
        int n3 = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isWhitespace(c)) {
                n3 = 0;
            } else if (n3 == n) {
                stringBuilder.append(string2);
                n3 = 0;
            } else {
                ++n3;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static String breakUpLongLines(String string, int n, String string2, int n2) {
        if (string == null) {
            return null;
        }
        if (string.length() < n || string2 == null) {
            return string;
        }
        if (n2 < n) {
            n2 = Integer.MAX_VALUE;
        }
        int n3 = string.length() + string2.length() * (string.length() / n);
        StringBuilder stringBuilder = new StringBuilder(n3);
        int n4 = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\n' || c == '\r') {
                stringBuilder.append(c);
                n4 = 0;
                continue;
            }
            if (n4 >= n && Character.isWhitespace(c)) {
                stringBuilder.append(string2);
                n4 = 0;
                continue;
            }
            if (n4 >= n2) {
                stringBuilder.append(string2);
                stringBuilder.append(c);
                n4 = 1;
                continue;
            }
            stringBuilder.append(c);
            ++n4;
        }
        return stringBuilder.toString();
    }

    public static boolean containsDoubleByteChars(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) <= '\u00ff') continue;
            return true;
        }
        return false;
    }

    public static boolean containsNonAscii7BitChars(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) <= '\u007f') continue;
            return true;
        }
        return false;
    }

    public static String convertToUnicodeLiteral(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length() * 6);
        for (int i = 0; i < string.length(); ++i) {
            char c;
            char c2 = c = string.charAt(i);
            int n = c2 % 256;
            int n2 = c2 >>> 8;
            stringBuilder.append("\\u");
            if (n2 < 16) {
                stringBuilder.append('0');
            }
            stringBuilder.append(Integer.toString(n2, 16));
            if (n < 16) {
                stringBuilder.append('0');
            }
            stringBuilder.append(Integer.toString(n, 16));
        }
        return stringBuilder.toString();
    }

    public static String showBytes(String string) {
        String string2 = StringUtil.getLineSeparator();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c;
            char c2 = c = string.charAt(i);
            int n = c2 % 256;
            int n2 = c2 >>> 8;
            stringBuilder.append("char " + i + ": " + n2 + ", " + n + "  hex: " + Integer.toString(n2, 16) + ", " + Integer.toString(n, 16));
            if (i >= string.length() - 1) continue;
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    public static String getLineSeparator() {
        return System.getProperty("line.separator");
    }

    private StringUtil() {
    }
}

